//
//  PeopleLoader.h
//  People
//
//  Created by Jonathan Diehl on 10.01.10.
//  Copyright 2010 RWTH. All rights reserved.
//

#import <Foundation/Foundation.h>

@class Person;
@class PeopleLoader;
@protocol PeopleLoaderDelegate
- (void)peopleLoader:(PeopleLoader *)peopleLoader didLoadPeople:(NSArray *)people;
- (void)peopleLoader:(PeopleLoader *)peopleLoader didFailWithError:(NSError *)error;
@end

@interface PeopleLoader : NSObject <NSXMLParserDelegate> {
	// connection variables
	NSURL *url;
	NSURLConnection *connection;
	NSMutableData *connectionData;
	
	// parser variables
	NSXMLParser *parser;
	NSString *parsedElement;
	NSMutableString *parsedCharacters;
	NSMutableArray *people;
	Person *person;
	
	// delegate
	id <PeopleLoaderDelegate> delegate;
}

@property(assign) id <PeopleLoaderDelegate> delegate;

- (id)initWithURL:(NSURL *)url;
- (void)load;

@end
